<?php
/*--------------------------------------------------------------------------------------------------
    ImplementationFactoryInterface.php 2020-01-23
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */
namespace Gambio\Shop\ProductModifiers\Database\Core\Factories\Interfaces;

use Gambio\Shop\ProductModifiers\Database\Core\Mappers\Interfaces\GroupMapperInterface;
use Gambio\Shop\ProductModifiers\Database\Core\Readers\Interfaces\GroupReaderCompositeInterface;
use Gambio\Shop\ProductModifiers\Database\Core\Readers\Interfaces\ModifierReaderCompositeInterface;
use Gambio\Shop\ProductModifiers\Database\Core\Readers\ModifierReaderComposite;

/**
 * Interface ImplementationFactoryInterface
 * @package Gambio\Shop\ProductModifiers\Database\Core\Factories\Interfaces
 */
interface ImplementationFactoryInterface
{
    /**
     * Defines the name of every implementation
     * @return string
     */
    public function source(): string;
    
    
    /**
     * @return GroupMapperInterface
     */
    public function createGroupMapper(): GroupMapperInterface;
    
    /**
     * @return ModifierReaderComposite
     */
    public function createModifierReader() : ModifierReaderCompositeInterface;
    
    
    /**
     * @return GroupReaderCompositeInterface
     */
    public function createGroupReader(): GroupReaderCompositeInterface;
    
    
}